<?php
require_once __DIR__ . '/config.php';
verifyApiKey();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit();
}

$input = getInput();
$userId = isset($input['userId']) ? (int)$input['userId'] : 0;
$currentPassword = isset($input['currentPassword']) ? $input['currentPassword'] : '';
$newPassword = isset($input['newPassword']) ? $input['newPassword'] : '';

if (!$userId || !$currentPassword || !$newPassword) {
    echo json_encode(['success' => false, 'error' => 'All fields are required']);
    exit();
}

if (strlen($newPassword) < 6) {
    echo json_encode(['success' => false, 'error' => 'New password must be at least 6 characters']);
    exit();
}

$db = getDB();

$stmt = $db->prepare('SELECT password FROM users WHERE id = ?');
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    echo json_encode(['success' => false, 'error' => 'User not found']);
    exit();
}

if (!password_verify($currentPassword, $user['password'])) {
    echo json_encode(['success' => false, 'error' => 'Current password is incorrect']);
    exit();
}

$hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT, ['cost' => 10]);
$stmt = $db->prepare('UPDATE users SET password = ? WHERE id = ?');
$stmt->execute([$hashedPassword, $userId]);

echo json_encode(['success' => true]);
?>
