<?php
require_once __DIR__ . '/config.php';
verifyApiKey();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit();
}

$input = getInput();
$username = isset($input['username']) ? trim($input['username']) : '';
$password = isset($input['password']) ? $input['password'] : '';

if (!$username || !$password) {
    echo json_encode(['success' => false, 'error' => 'Username and password are required']);
    exit();
}

$uname = strtolower($username);
$db = getDB();

$stmt = $db->prepare('SELECT id, fullName, username, email, password, role, avatar, createdAt, lastLogin FROM users WHERE (username = ? OR email = ?) AND isActive = 1');
$stmt->execute([$uname, $uname]);
$user = $stmt->fetch();

if (!$user) {
    echo json_encode(['success' => false, 'error' => 'User not found']);
    exit();
}

if (!password_verify($password, $user['password'])) {
    echo json_encode(['success' => false, 'error' => 'Incorrect password']);
    exit();
}

// Update last login
$stmt = $db->prepare('UPDATE users SET lastLogin = NOW() WHERE id = ?');
$stmt->execute([$user['id']]);

// Record login history
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$stmt = $db->prepare('INSERT INTO login_history (userId, ipAddress) VALUES (?, ?)');
$stmt->execute([$user['id'], $ip]);

echo json_encode([
    'success' => true,
    'user' => [
        'id' => (int)$user['id'],
        'fullName' => $user['fullName'],
        'username' => $user['username'],
        'email' => $user['email'],
        'role' => $user['role'],
        'avatar' => $user['avatar'] ?? '',
        'createdAt' => $user['createdAt'],
        'lastLogin' => date('c')
    ]
]);
?>
