<?php
require_once __DIR__ . '/config.php';
verifyApiKey();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit();
}

$input = getInput();
$fullName = isset($input['fullName']) ? trim($input['fullName']) : '';
$username = isset($input['username']) ? trim($input['username']) : '';
$email = isset($input['email']) ? trim($input['email']) : '';
$password = isset($input['password']) ? $input['password'] : '';

// Validation
if (!$fullName || !$username || !$email || !$password) {
    echo json_encode(['success' => false, 'error' => 'All fields are required']);
    exit();
}

if (strlen($username) < 3) {
    echo json_encode(['success' => false, 'error' => 'Username must be at least 3 characters']);
    exit();
}

if (strlen($password) < 6) {
    echo json_encode(['success' => false, 'error' => 'Password must be at least 6 characters']);
    exit();
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'error' => 'Invalid email format']);
    exit();
}

$username = strtolower($username);
$email = strtolower($email);

$db = getDB();

// Check if username exists
$stmt = $db->prepare('SELECT id FROM users WHERE username = ?');
$stmt->execute([$username]);
if ($stmt->fetch()) {
    echo json_encode(['success' => false, 'error' => 'Username already taken']);
    exit();
}

// Check if email exists
$stmt = $db->prepare('SELECT id FROM users WHERE email = ?');
$stmt->execute([$email]);
if ($stmt->fetch()) {
    echo json_encode(['success' => false, 'error' => 'Email already registered']);
    exit();
}

// Hash password and insert
$hashedPassword = password_hash($password, PASSWORD_BCRYPT, ['cost' => 10]);

$stmt = $db->prepare('INSERT INTO users (fullName, username, email, password) VALUES (?, ?, ?, ?)');
$stmt->execute([$fullName, $username, $email, $hashedPassword]);

$userId = $db->lastInsertId();

echo json_encode([
    'success' => true,
    'user' => [
        'id' => (int)$userId,
        'fullName' => $fullName,
        'username' => $username,
        'email' => $email,
        'role' => 'user'
    ]
]);
?>
