<?php
require_once __DIR__ . '/config.php';
verifyApiKey();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit();
}

$input = getInput();
$userId = isset($input['userId']) ? (int)$input['userId'] : 0;
$fullName = isset($input['fullName']) ? trim($input['fullName']) : '';
$email = isset($input['email']) ? trim($input['email']) : '';
$avatar = isset($input['avatar']) ? $input['avatar'] : null;

if (!$userId) {
    echo json_encode(['success' => false, 'error' => 'User ID is required']);
    exit();
}

$db = getDB();

$updates = [];
$values = [];

if ($fullName) {
    $updates[] = 'fullName = ?';
    $values[] = $fullName;
}
if ($email) {
    $email = strtolower($email);
    // Check if email is taken by another user
    $stmt = $db->prepare('SELECT id FROM users WHERE email = ? AND id != ?');
    $stmt->execute([$email, $userId]);
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'error' => 'Email already in use']);
        exit();
    }
    $updates[] = 'email = ?';
    $values[] = $email;
}
if ($avatar !== null) {
    $updates[] = 'avatar = ?';
    $values[] = $avatar;
}

if (empty($updates)) {
    echo json_encode(['success' => false, 'error' => 'Nothing to update']);
    exit();
}

$values[] = $userId;
$sql = 'UPDATE users SET ' . implode(', ', $updates) . ' WHERE id = ?';
$stmt = $db->prepare($sql);
$stmt->execute($values);

// Fetch updated user
$stmt = $db->prepare('SELECT id, fullName, username, email, role, avatar, createdAt, lastLogin FROM users WHERE id = ?');
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    echo json_encode(['success' => false, 'error' => 'User not found after update']);
    exit();
}

$user['id'] = (int)$user['id'];

echo json_encode(['success' => true, 'user' => $user]);
?>
